/**
 * User handler
 *   - keeps user information
 *   - maintains conversations, contact list, profiles, histories
 * 
 * @param {Core} owner
 * @param {Object} info
 */
var User = new Class({  
  owner: null,
	el: null,
  id: null,
  info: null,
	contacts: new Hash(),
	conversations: new Hash(),
	profiles: new Hash(),
	histories: new Hash(),
  refresh_interval: settings.refresh_interval,
	refresh_timer: null,
	
  initialize: function(owner, info){
		this.owner = owner;
		if($defined(info)) this.loadInfo(info);
		
    this.owner.loadCSS('user');
		var tpl = new Template("user");
    this.el = new Element('div').adopt(tpl.xml).getFirst();
	 
	  // Setup periodical refreshing
    // reloads contacts and opens new incomming conversation windows
		this.refresh_timer = this.refreshInformation.periodical(this.refresh_interval, this);
		
		// Associate events
		this.el.getElement('a.cprofile').addEvent('click', function(){
			if (this.info.anonymous) {
		  	showMessage('Neregistrovaní používatelia nemôžu upravovať svoj profil');
		  } else {
		  	this.showProfile();
		  }
		}.bind(this));
  },
	
	getEl: function(){
		var nickel = this.el.getElement('.nick');
		if ($defined(nickel)) nickel.set('html', this.info.nick);
		return this.el;
	},
	
  logout: function(manual){
		// stop periodical getting of new messages
		this.refresh_timer = $clear(this.refresh_timer);
		
    // try to make logout request
    this.owner.server.request({'action': 'logout', 'args': {}});
		
    // Pseudolambda function for closing items (windows) after logging out
    var item_closer = function(item){ item.close(); }
		
    this.conversations.each(item_closer);
    this.profiles.each(item_closer);
    this.histories.each(item_closer);
    
		this.fireEvent('logout');
		
		// remove stored login information
	  if (manual) Login.resetLoginInfo();
  },
  
	// set user information
	loadInfo: function(info){
		this.id = info['id'];
    this.info = info;
		this.info.anonymous = this.info.anonymous == "1";
    this.fireEvent('InfoUpdate');
	},
	
	// set contacts to contact list
	loadContacts: function(list){
    this.contacts.empty();
		$each(list, function(item){
	    this.contacts.set(item.id, item);
		}.bind(this));
    this.fireEvent('ContactListUpdate');
	},
	
	removeContact: function(id_user){
    this.owner.server.request({'action': 'remove_contact', 'args': {'id_contact': id_user}}, function(response){
      if(!$defined(response) || !$defined(response.contacts)){
        showError('Chyba: nepodarilo sa odstrániť kontakt.');
      
      } else {
				this.closeConversation(id_user);
        this.closeProfile(id_user);
        this.closeContactHistory(id_user);
				this.loadContacts(response.contacts);
        this.fireEvent('ContactListUpdate');
      }
    }.bind(this));
	},
  
  addContact: function(id_user, onComplete){
    this.owner.server.request({'action': 'add_contact', 'args': {'id_contact': id_user}}, function(response){
      if(!$defined(response) || !$defined(response.contacts)){
        showError('Chyba: nepodarilo sa pridať kontakt.');
        if($defined(onComplete)) onComplete(false);
				
      } else {
        this.loadContacts(response.contacts);
        this.fireEvent('ContactListUpdate');
				if($defined(onComplete)) onComplete(true);
      }
    }.bind(this));
  },
	
	startConversation: function(id_user){
		if(!this.conversations.has(id_user)){
			this.conversations.set(id_user, new Conversation(this.owner, id_user));			
		}
		this.conversations.get(id_user).open();
	},
	
	closeConversation: function(id_user){
		if (this.conversations.has(id_user)) {
			this.conversations.get(id_user).close();
			this.conversations.erase(id_user);
		}
	},
	
	showContactProfile: function(id_user){
		if(!this.profiles.has(id_user)){
			this.profiles.set(id_user, new Profile(this.owner, {editable: this.info.anonymous ? [] : ['nick']}, this.contacts.get(id_user)));			
		}
		this.profiles.get(id_user).open();		
	},
	
	showContactHistory: function(id_user){
		if(!this.histories.has(id_user)){
			this.histories.set(id_user, new History(this.owner, {}, this.contacts.get(id_user)));			
		}
		this.histories.get(id_user).open();		
	},
	
	closeContactHistory: function(id_user){
		if (this.histories.has(id_user)) {
      this.histories.get(id_user).close();
			this.histories.erase(id_user);
		}  		
	},
	
	showProfile: function(){
		if(!this.profiles.has(this.id)){
			var info = new Hash(this.info);
			this.profiles.set(this.id, new Profile(this.owner, {editable: info.getKeys()}, this.info));			
		}
		this.profiles.get(this.id).open();		
	},
	
	closeProfile: function(id_user){
		if (this.profiles.has(id_user)) {
      this.profiles.get(id_user).close();
			this.profiles.erase(id_user);
		}
	},
	
	// obnovi konverzacie - nacita do nich nove spravy pripadne zacne nove konverzacie
	// nastavi nove stavy na kontaktoch
	refreshInformation: function(){
    this.owner.server.request(
		  {'action': 'get_information', 'args': {'get_contacts': {}, 'get_messages': {}, 'get_transfers': {}, 'get_user_info': {}}},
			this.refreshInformationHandler.bind(this), 
			{background: true}
		);
	}, 
	
	refreshInformationHandler: function(response){
		if (!$defined(this.owner.user)) return false;
		
    if($defined(response)){
      if ($defined(response.contacts)) {
        this.loadContacts(response.contacts);
        this.fireEvent('ContactListUpdate');
      }
      
      if ($defined(response.messages)){
        $each(response.messages, function(msg){
          // vytvorime novu (resp. obnovime staru) konverzaciu
          this.startConversation(msg.id_user_contact);
          
          // vlozime spravu do konverzacie
					this.conversations.get(msg.id_user_contact).addIncomingMessage(msg);
        }, this);
      }
			
      if ($defined(response.transfers)){
        $each(response.transfers, function(transfer){
          // vytvorime novu (resp. obnovime staru) konverzaciu
          this.startConversation(transfer.id_user_contact);
          
          // vlozime spravu do konverzacie
          this.conversations.get(transfer.id_user_contact).addIncomingTransfer(transfer);
        }, this);
      }
      
      if ($defined(response.user)){
        this.loadInfo(response.user);
        this.getEl();
      }
    }
	}
});

User.implement(new Events);